#!/usr/bin/perl

use strict;
use DBI;

# NDO Database Settings
my $ndoHost = 'localhost';
my $ndoUser = 'racktables';
my $ndoPass = 'passw0rd';
my $ndoDatabase = 'ndoutils'; # Use centreon_status if you have an centreon based setup

# Racktables Database Settings
my $racktablesHost = 'localhost';
my $racktablesUser = 'rackuser';
my $racktablesPass = 'passw0rd';
my $racktablesDatabase = 'racktables';

# ----------------------------------------------------------------------------------------------------------------------------------------

my $ndoDSN = "DBI:mysql:$ndoDatabase:$ndoHost";
my $racktablesDSN = "DBI:mysql:$racktablesDatabase:$racktablesHost";

my $ndoConnection = DBI->connect($ndoDSN, $ndoUser, $ndoPass) || die "Could not connect to NDO database.";

my $racktablesConnection = DBI->connect($racktablesDSN, $racktablesUser, $racktablesPass) || die "Could not connect to Racktables database.";

# Reset all has_problems in racktables
my $query = 'UPDATE RackObject SET has_problems=0;';
$racktablesConnection->do($query) || die "Could not reset racktables problems.";

# Set all host problems to has_problems in racktables
$query = 'Select h.alias, h.display_name, s.current_state from nagios_hoststatus s inner join nagios_hosts h ON h.host_object_id = s.host_object_id WHERE s.current_state=1 OR s.current_state=2;';
my $hostStatement = $ndoConnection->prepare($query);
$hostStatement->execute();

while ( my @HostArray = $hostStatement->fetchrow_array() ) {
  $racktablesConnection->do("UPDATE RackObject SET has_problems=1 WHERE name='@HostArray[1]';")
}

# Set all hosts with service problems to has_problems in racktables
$query = 'Select h.alias, h.display_name, s.current_state from nagios_servicestatus s inner join nagios_services se ON se.service_object_id = s.service_object_id inner join nagios_hosts h ON h.host_object_id = se.host_object_id WHERE s.current_state=1 OR s.current_state=2;';
my $serviceStatement = $ndoConnection->prepare($query);
$serviceStatement->execute();

while ( my @ServiceArray = $serviceStatement->fetchrow_array() ) {
  $racktablesConnection->do("UPDATE RackObject SET has_problems=1 WHERE name='@ServiceArray[1]';")
}

# Disconnect
$ndoConnection->disconnect();
$racktablesConnection->disconnect();

